/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.question.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.infra.question.services.QuestionService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/questions"})
public class QuestionController {
    private final QuestionService questionService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<QuestionEntity>>> getAllQuestions() {
        List questions = this.questionService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)questions, (String)"Quest\u00f5es obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<QuestionEntity>> getQuestionById(@PathVariable Long id) {
        QuestionEntity question = this.questionService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)question, (String)"Quest\u00e3o obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<QuestionEntity>> createQuestion(@Valid @RequestBody QuestionEntity question) {
        QuestionEntity created = this.questionService.save(question);
        WebResponseEntity response = WebResponseEntity.success((Object)created, (String)"Quest\u00e3o criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<QuestionEntity>> updateQuestion(@PathVariable Long id, @Valid @RequestBody QuestionEntity question) {
        question.setId(id);
        QuestionEntity updated = this.questionService.update(question);
        WebResponseEntity response = WebResponseEntity.success((Object)updated, (String)"Quest\u00e3o atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteQuestion(@PathVariable Long id) {
        this.questionService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Quest\u00e3o exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public QuestionController(QuestionService questionService) {
        this.questionService = questionService;
    }
}

