/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.atributions_permission.services;

import com.geosegbar.entities.AttributionsPermissionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.permissions.atributions_permission.dtos.AttributionsPermissionDTO;
import com.geosegbar.infra.permissions.atributions_permission.persistence.AttributionsPermissionRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttributionsPermissionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttributionsPermissionService.class);
    private final AttributionsPermissionRepository attrPermissionRepository;
    private final UserRepository userRepository;

    public List<AttributionsPermissionEntity> findAll() {
        return this.attrPermissionRepository.findAll();
    }

    public AttributionsPermissionEntity findById(Long id) {
        return (AttributionsPermissionEntity)this.attrPermissionRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de atribui\u00e7\u00f5es n\u00e3o encontrada com ID: " + id));
    }

    public AttributionsPermissionEntity findByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        return (AttributionsPermissionEntity)this.attrPermissionRepository.findByUser(user).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de atribui\u00e7\u00f5es n\u00e3o encontrada para o usu\u00e1rio!"));
    }

    @Transactional
    public AttributionsPermissionEntity createOrUpdate(AttributionsPermissionDTO permissionDTO) {
        AttributionsPermissionEntity permission;
        UserEntity user = (UserEntity)this.userRepository.findById((Object)permissionDTO.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + permissionDTO.getUserId()));
        Optional existingPermission = this.attrPermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = (AttributionsPermissionEntity)existingPermission.get();
        } else {
            permission = new AttributionsPermissionEntity();
            permission.setUser(user);
        }
        permission.setEditUser(permissionDTO.getEditUser());
        permission.setEditDam(permissionDTO.getEditDam());
        permission.setEditGeralData(permissionDTO.getEditGeralData());
        return (AttributionsPermissionEntity)this.attrPermissionRepository.save((Object)permission);
    }

    @Transactional
    public void delete(Long id) {
        if (!this.attrPermissionRepository.existsById((Object)id)) {
            throw new NotFoundException("Permiss\u00e3o de atribui\u00e7\u00f5es n\u00e3o encontrada com ID: " + id);
        }
        this.attrPermissionRepository.deleteById((Object)id);
    }

    @Transactional
    public void deleteByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        if (!this.attrPermissionRepository.existsByUser(user)) {
            throw new NotFoundException("Permiss\u00e3o de atribui\u00e7\u00f5es n\u00e3o encontrada para o usu\u00e1rio");
        }
        AttributionsPermissionEntity permission = (AttributionsPermissionEntity)this.attrPermissionRepository.findByUser(user).get();
        permission.setUser(null);
        this.attrPermissionRepository.delete((Object)permission);
    }

    @Transactional
    public void deleteByUserSafely(Long userId) {
        try {
            UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
            if (this.attrPermissionRepository.existsByUser(user)) {
                AttributionsPermissionEntity permission = (AttributionsPermissionEntity)this.attrPermissionRepository.findByUser(user).get();
                user.setAttributionsPermission(null);
                permission.setUser(null);
                this.userRepository.save((Object)user);
                this.attrPermissionRepository.save((Object)permission);
                this.attrPermissionRepository.delete((Object)permission);
            }
        }
        catch (Exception e) {
            log.error("Error while trying to delete attributions permission for user {}: {}", new Object[]{userId, e.getMessage(), e});
        }
    }

    @Transactional
    public AttributionsPermissionEntity createDefaultPermission(UserEntity user) {
        if (this.attrPermissionRepository.existsByUser(user)) {
            return (AttributionsPermissionEntity)this.attrPermissionRepository.findByUser(user).get();
        }
        AttributionsPermissionEntity permission = new AttributionsPermissionEntity();
        permission.setUser(user);
        permission.setEditUser(Boolean.valueOf(false));
        permission.setEditDam(Boolean.valueOf(false));
        permission.setEditGeralData(Boolean.valueOf(false));
        AttributionsPermissionEntity savedPermission = (AttributionsPermissionEntity)this.attrPermissionRepository.save((Object)permission);
        return savedPermission;
    }

    @Generated
    public AttributionsPermissionService(AttributionsPermissionRepository attrPermissionRepository, UserRepository userRepository) {
        this.attrPermissionRepository = attrPermissionRepository;
        this.userRepository = userRepository;
    }
}

