/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_tabulate_pattern.services;

import com.geosegbar.common.utils.InstrumentTabulatePatternMapper;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.InstrumentTabulateAssociationEntity;
import com.geosegbar.entities.InstrumentTabulateOutputAssociationEntity;
import com.geosegbar.entities.InstrumentTabulatePatternEntity;
import com.geosegbar.entities.InstrumentTabulatePatternFolder;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.instrument.services.InstrumentService;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.CreateTabulatePatternRequestDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.TabulatePatternResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.UpdateTabulatePatternRequestDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.persistence.jpa.InstrumentTabulatePatternRepository;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.services.InstrumentTabulatePatternFolderService;
import com.geosegbar.infra.output.services.OutputService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentTabulatePatternService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentTabulatePatternService.class);
    private final InstrumentTabulatePatternRepository patternRepository;
    private final DamService damService;
    private final InstrumentService instrumentService;
    private final OutputService outputService;
    private final InstrumentTabulatePatternFolderService folderService;
    private final InstrumentTabulatePatternMapper mapper;

    @Transactional
    @CacheEvict(value={"tabulatePatterns", "tabulatePatternsByDam", "tabulatePatternsByFolder", "tabulateFolderWithPatterns", "damTabulateFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentTabulateCacheManager")
    public TabulatePatternResponseDTO create(CreateTabulatePatternRequestDTO request) {
        if (this.patternRepository.existsByNameAndDamId(request.getName(), request.getDamId())) {
            throw new DuplicateResourceException("J\u00e1 existe um padr\u00e3o de tabela com o nome '" + request.getName() + "' nesta barragem!");
        }
        DamEntity dam = this.damService.findById(request.getDamId());
        InstrumentTabulatePatternFolder folder = null;
        if (request.getFolderId() != null && !(folder = this.folderService.findById(request.getFolderId())).getDam().getId().equals(dam.getId())) {
            throw new InvalidInputException("A pasta selecionada n\u00e3o pertence \u00e0 barragem informada!");
        }
        InstrumentTabulatePatternEntity pattern = new InstrumentTabulatePatternEntity();
        pattern.setName(request.getName());
        pattern.setDam(dam);
        pattern.setFolder(folder);
        pattern = (InstrumentTabulatePatternEntity)this.patternRepository.save((Object)pattern);
        HashSet associations = new HashSet();
        this.validateAndProcessInstrumentAssociations(request.getAssociations(), pattern, associations);
        pattern.setAssociations(associations);
        pattern = (InstrumentTabulatePatternEntity)this.patternRepository.save((Object)pattern);
        log.info("Padr\u00e3o de tabela criado: id={}, name={}, damId={}, folderId={}", new Object[]{pattern.getId(), pattern.getName(), dam.getId(), folder != null ? folder.getId() : "sem pasta"});
        return this.mapper.mapToResponseDTO((InstrumentTabulatePatternEntity)this.patternRepository.findByIdWithAllDetails(pattern.getId()).orElseThrow(() -> new NotFoundException("Padr\u00e3o de tabela n\u00e3o encontrado ap\u00f3s cria\u00e7\u00e3o")));
    }

    @Transactional
    @CacheEvict(value={"tabulatePatterns", "tabulatePatternsByDam", "tabulatePatternsByFolder", "tabulateFolderWithPatterns", "damTabulateFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentTabulateCacheManager")
    public void delete(Long patternId) {
        InstrumentTabulatePatternEntity pattern = (InstrumentTabulatePatternEntity)this.patternRepository.findByIdWithBasicDetails(patternId).orElseThrow(() -> new NotFoundException("Padr\u00e3o de tabela n\u00e3o encontrado com ID: " + patternId));
        log.info("Excluindo padr\u00e3o de tabela: id={}, name={}, damId={}, folderId={}", new Object[]{pattern.getId(), pattern.getName(), pattern.getDam() != null ? pattern.getDam().getId() : null, pattern.getFolder() != null ? pattern.getFolder().getId() : null});
        this.patternRepository.delete((Object)pattern);
        log.info("Padr\u00e3o de tabela exclu\u00eddo com sucesso: id={}", (Object)patternId);
    }

    @Transactional
    @CacheEvict(value={"tabulatePatterns", "tabulatePatternsByDam", "tabulatePatternsByFolder", "tabulateFolderWithPatterns", "damTabulateFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentTabulateCacheManager")
    public TabulatePatternResponseDTO update(Long patternId, UpdateTabulatePatternRequestDTO request) {
        InstrumentTabulatePatternEntity pattern = this.findEntityByIdWithAllDetails(patternId);
        if (!pattern.getName().equals(request.getName()) && this.patternRepository.existsByNameAndDamIdAndIdNot(request.getName(), pattern.getDam().getId(), patternId)) {
            throw new DuplicateResourceException("J\u00e1 existe um padr\u00e3o de tabela com o nome '" + request.getName() + "' nesta barragem!");
        }
        InstrumentTabulatePatternFolder folder = null;
        if (request.getFolderId() != null && !(folder = this.folderService.findById(request.getFolderId())).getDam().getId().equals(pattern.getDam().getId())) {
            throw new InvalidInputException("A pasta selecionada n\u00e3o pertence \u00e0 barragem do padr\u00e3o!");
        }
        pattern.setName(request.getName());
        pattern.setFolder(folder);
        Set currentAssociations = pattern.getAssociations();
        HashSet newAssociations = new HashSet();
        Map<Long, InstrumentTabulateAssociationEntity> associationsMap = currentAssociations.stream().collect(Collectors.toMap(InstrumentTabulateAssociationEntity::getId, a -> a));
        this.validateAndUpdateInstrumentAssociations(request.getAssociations(), pattern, newAssociations, associationsMap);
        pattern.getAssociations().clear();
        pattern.getAssociations().addAll(newAssociations);
        pattern = (InstrumentTabulatePatternEntity)this.patternRepository.save((Object)pattern);
        log.info("Padr\u00e3o de tabela atualizado: id={}, name={}, damId={}, folderId={}", new Object[]{pattern.getId(), pattern.getName(), pattern.getDam().getId(), folder != null ? folder.getId() : "sem pasta"});
        return this.mapper.mapToResponseDTO((InstrumentTabulatePatternEntity)this.patternRepository.findByIdWithAllDetails(pattern.getId()).orElseThrow(() -> new NotFoundException("Padr\u00e3o de tabela n\u00e3o encontrado ap\u00f3s atualiza\u00e7\u00e3o")));
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"tabulatePatterns"}, key="#patternId", cacheManager="instrumentTabulateCacheManager")
    public TabulatePatternResponseDTO findById(Long patternId) {
        InstrumentTabulatePatternEntity pattern = this.findEntityByIdWithAllDetails(patternId);
        return this.mapper.mapToResponseDTO(pattern);
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"tabulatePatternsByDam"}, key="#damId", cacheManager="instrumentTabulateCacheManager")
    public List<TabulatePatternResponseDTO> findByDamId(Long damId) {
        this.damService.findById(damId);
        List patterns = this.patternRepository.findByDamIdWithAllDetails(damId);
        return patterns.stream().map(arg_0 -> ((InstrumentTabulatePatternMapper)this.mapper).mapToResponseDTO(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"tabulatePatternsByFolder"}, key="#folderId", cacheManager="instrumentTabulateCacheManager")
    public List<TabulatePatternResponseDTO> findByFolderId(Long folderId) {
        this.folderService.findById(folderId);
        List patterns = this.patternRepository.findByFolderIdWithAllDetails(folderId);
        return patterns.stream().map(arg_0 -> ((InstrumentTabulatePatternMapper)this.mapper).mapToResponseDTO(arg_0)).collect(Collectors.toList());
    }

    public InstrumentTabulatePatternEntity findEntityByIdWithAllDetails(Long patternId) {
        return (InstrumentTabulatePatternEntity)this.patternRepository.findByIdWithAllDetails(patternId).orElseThrow(() -> new NotFoundException("Padr\u00e3o de tabela n\u00e3o encontrado com ID: " + patternId));
    }

    private void validateAndProcessInstrumentAssociations(List<CreateTabulatePatternRequestDTO.InstrumentAssociationDTO> associationDTOs, InstrumentTabulatePatternEntity pattern, Set<InstrumentTabulateAssociationEntity> associations) {
        HashSet usedIndices = new HashSet();
        int nextAvailableIndex = 1;
        for (CreateTabulatePatternRequestDTO.InstrumentAssociationDTO dto : associationDTOs) {
            InstrumentEntity instrument = this.instrumentService.findById(dto.getInstrumentId());
            if (!instrument.getDam().getId().equals(pattern.getDam().getId())) {
                throw new InvalidInputException("O instrumento com ID " + dto.getInstrumentId() + " n\u00e3o pertence \u00e0 barragem do padr\u00e3o!");
            }
            InstrumentTabulateAssociationEntity association = new InstrumentTabulateAssociationEntity();
            association.setPattern(pattern);
            association.setInstrument(instrument);
            this.configureBaseColumns(dto, association, usedIndices, nextAvailableIndex);
            nextAvailableIndex = this.getNextAvailableIndex(usedIndices);
            this.processOutputAssociations(dto.getOutputAssociations(), association, instrument, usedIndices, nextAvailableIndex);
            nextAvailableIndex = this.getNextAvailableIndex(usedIndices);
            associations.add(association);
        }
    }

    private void validateAndUpdateInstrumentAssociations(List<UpdateTabulatePatternRequestDTO.InstrumentAssociationDTO> associationDTOs, InstrumentTabulatePatternEntity pattern, Set<InstrumentTabulateAssociationEntity> newAssociations, Map<Long, InstrumentTabulateAssociationEntity> existingAssociationsMap) {
        HashSet usedIndices = new HashSet();
        int nextAvailableIndex = 1;
        for (UpdateTabulatePatternRequestDTO.InstrumentAssociationDTO dto : associationDTOs) {
            InstrumentTabulateAssociationEntity association;
            if (dto.getId() != null && existingAssociationsMap.containsKey(dto.getId())) {
                association = existingAssociationsMap.get(dto.getId());
                if (!association.getInstrument().getId().equals(dto.getInstrumentId())) {
                    InstrumentEntity newInstrument = this.instrumentService.findById(dto.getInstrumentId());
                    if (!newInstrument.getDam().getId().equals(pattern.getDam().getId())) {
                        throw new InvalidInputException("O instrumento com ID " + dto.getInstrumentId() + " n\u00e3o pertence \u00e0 barragem do padr\u00e3o!");
                    }
                    association.setInstrument(newInstrument);
                }
                association.getOutputAssociations().clear();
            } else {
                association = new InstrumentTabulateAssociationEntity();
                association.setPattern(pattern);
                InstrumentEntity instrument = this.instrumentService.findById(dto.getInstrumentId());
                if (!instrument.getDam().getId().equals(pattern.getDam().getId())) {
                    throw new InvalidInputException("O instrumento com ID " + dto.getInstrumentId() + " n\u00e3o pertence \u00e0 barragem do padr\u00e3o!");
                }
                association.setInstrument(instrument);
            }
            this.configureBaseColumnsForUpdate(dto, association, usedIndices, nextAvailableIndex);
            nextAvailableIndex = this.getNextAvailableIndex(usedIndices);
            this.processOutputAssociationsForUpdate(dto.getOutputAssociations(), association, association.getInstrument(), usedIndices, nextAvailableIndex);
            nextAvailableIndex = this.getNextAvailableIndex(usedIndices);
            newAssociations.add(association);
        }
    }

    private void configureBaseColumns(CreateTabulatePatternRequestDTO.InstrumentAssociationDTO dto, InstrumentTabulateAssociationEntity association, Set<Integer> usedIndices, int nextAvailableIndex) {
        if (Boolean.TRUE.equals(dto.getIsDateEnable())) {
            association.setIsDateEnable(Boolean.valueOf(true));
            if (dto.getDateIndex() != null) {
                if (usedIndices.contains(dto.getDateIndex())) {
                    throw new InvalidInputException("\u00cdndice duplicado: " + dto.getDateIndex());
                }
                association.setDateIndex(dto.getDateIndex());
                usedIndices.add(dto.getDateIndex());
            } else {
                association.setDateIndex(Integer.valueOf(nextAvailableIndex));
                usedIndices.add(nextAvailableIndex);
                ++nextAvailableIndex;
            }
        } else {
            association.setIsDateEnable(Boolean.valueOf(false));
            association.setDateIndex(null);
        }
        if (Boolean.TRUE.equals(dto.getIsHourEnable())) {
            association.setIsHourEnable(Boolean.valueOf(true));
            if (dto.getHourIndex() != null) {
                if (usedIndices.contains(dto.getHourIndex())) {
                    throw new InvalidInputException("\u00cdndice duplicado: " + dto.getHourIndex());
                }
                association.setHourIndex(dto.getHourIndex());
                usedIndices.add(dto.getHourIndex());
            } else {
                association.setHourIndex(Integer.valueOf(nextAvailableIndex));
                usedIndices.add(nextAvailableIndex);
                ++nextAvailableIndex;
            }
        } else {
            association.setIsHourEnable(Boolean.valueOf(false));
            association.setHourIndex(null);
        }
        if (Boolean.TRUE.equals(dto.getIsUserEnable())) {
            association.setIsUserEnable(Boolean.valueOf(true));
            if (dto.getUserIndex() != null) {
                if (usedIndices.contains(dto.getUserIndex())) {
                    throw new InvalidInputException("\u00cdndice duplicado: " + dto.getUserIndex());
                }
                association.setUserIndex(dto.getUserIndex());
                usedIndices.add(dto.getUserIndex());
            } else {
                association.setUserIndex(Integer.valueOf(nextAvailableIndex));
                usedIndices.add(nextAvailableIndex);
                ++nextAvailableIndex;
            }
        } else {
            association.setIsUserEnable(Boolean.valueOf(false));
            association.setUserIndex(null);
        }
        association.setIsReadEnable(dto.getIsReadEnable());
    }

    private void configureBaseColumnsForUpdate(UpdateTabulatePatternRequestDTO.InstrumentAssociationDTO dto, InstrumentTabulateAssociationEntity association, Set<Integer> usedIndices, int nextAvailableIndex) {
        if (Boolean.TRUE.equals(dto.getIsDateEnable())) {
            association.setIsDateEnable(Boolean.valueOf(true));
            if (dto.getDateIndex() != null) {
                if (usedIndices.contains(dto.getDateIndex())) {
                    throw new InvalidInputException("\u00cdndice duplicado: " + dto.getDateIndex());
                }
                association.setDateIndex(dto.getDateIndex());
                usedIndices.add(dto.getDateIndex());
            } else {
                association.setDateIndex(Integer.valueOf(nextAvailableIndex));
                usedIndices.add(nextAvailableIndex);
                ++nextAvailableIndex;
            }
        } else {
            association.setIsDateEnable(Boolean.valueOf(false));
            association.setDateIndex(null);
        }
        if (Boolean.TRUE.equals(dto.getIsHourEnable())) {
            association.setIsHourEnable(Boolean.valueOf(true));
            if (dto.getHourIndex() != null) {
                if (usedIndices.contains(dto.getHourIndex())) {
                    throw new InvalidInputException("\u00cdndice duplicado: " + dto.getHourIndex());
                }
                association.setHourIndex(dto.getHourIndex());
                usedIndices.add(dto.getHourIndex());
            } else {
                association.setHourIndex(Integer.valueOf(nextAvailableIndex));
                usedIndices.add(nextAvailableIndex);
                ++nextAvailableIndex;
            }
        } else {
            association.setIsHourEnable(Boolean.valueOf(false));
            association.setHourIndex(null);
        }
        if (Boolean.TRUE.equals(dto.getIsUserEnable())) {
            association.setIsUserEnable(Boolean.valueOf(true));
            if (dto.getUserIndex() != null) {
                if (usedIndices.contains(dto.getUserIndex())) {
                    throw new InvalidInputException("\u00cdndice duplicado: " + dto.getUserIndex());
                }
                association.setUserIndex(dto.getUserIndex());
                usedIndices.add(dto.getUserIndex());
            } else {
                association.setUserIndex(Integer.valueOf(nextAvailableIndex));
                usedIndices.add(nextAvailableIndex);
                ++nextAvailableIndex;
            }
        } else {
            association.setIsUserEnable(Boolean.valueOf(false));
            association.setUserIndex(null);
        }
        association.setIsReadEnable(dto.getIsReadEnable());
    }

    private void processOutputAssociations(List<CreateTabulatePatternRequestDTO.OutputAssociationDTO> outputDTOs, InstrumentTabulateAssociationEntity association, InstrumentEntity instrument, Set<Integer> usedIndices, int nextAvailableIndex) {
        if (outputDTOs.isEmpty()) {
            throw new InvalidInputException("Pelo menos uma associa\u00e7\u00e3o de output \u00e9 obrigat\u00f3ria para o instrumento " + instrument.getName());
        }
        HashSet<Long> processedOutputIds = new HashSet<Long>();
        HashSet<InstrumentTabulateOutputAssociationEntity> outputAssociations = new HashSet<InstrumentTabulateOutputAssociationEntity>();
        for (CreateTabulatePatternRequestDTO.OutputAssociationDTO dto : outputDTOs) {
            OutputEntity output = this.outputService.findById(dto.getOutputId());
            if (!output.getInstrument().getId().equals(instrument.getId())) {
                throw new InvalidInputException("O output com ID " + dto.getOutputId() + " n\u00e3o pertence ao instrumento com ID " + instrument.getId());
            }
            if (processedOutputIds.contains(dto.getOutputId())) {
                throw new InvalidInputException("Output duplicado: " + output.getName());
            }
            processedOutputIds.add(dto.getOutputId());
            int outputIndex = Optional.ofNullable(dto.getOutputIndex()).orElse(nextAvailableIndex);
            if (usedIndices.contains(outputIndex)) {
                throw new InvalidInputException("\u00cdndice duplicado: " + outputIndex);
            }
            usedIndices.add(outputIndex);
            InstrumentTabulateOutputAssociationEntity outputAssociation = new InstrumentTabulateOutputAssociationEntity();
            outputAssociation.setAssociation(association);
            outputAssociation.setOutput(output);
            outputAssociation.setOutputIndex(Integer.valueOf(outputIndex));
            outputAssociations.add(outputAssociation);
            nextAvailableIndex = this.getNextAvailableIndex(usedIndices);
        }
        association.setOutputAssociations(outputAssociations);
    }

    private void processOutputAssociationsForUpdate(List<UpdateTabulatePatternRequestDTO.OutputAssociationDTO> outputDTOs, InstrumentTabulateAssociationEntity association, InstrumentEntity instrument, Set<Integer> usedIndices, int nextAvailableIndex) {
        if (outputDTOs.isEmpty()) {
            throw new InvalidInputException("Pelo menos uma associa\u00e7\u00e3o de output \u00e9 obrigat\u00f3ria para o instrumento " + instrument.getName());
        }
        HashSet<Long> processedOutputIds = new HashSet<Long>();
        HashSet<InstrumentTabulateOutputAssociationEntity> outputAssociations = new HashSet<InstrumentTabulateOutputAssociationEntity>();
        for (UpdateTabulatePatternRequestDTO.OutputAssociationDTO dto : outputDTOs) {
            OutputEntity output = this.outputService.findById(dto.getOutputId());
            if (!output.getInstrument().getId().equals(instrument.getId())) {
                throw new InvalidInputException("O output com ID " + dto.getOutputId() + " n\u00e3o pertence ao instrumento com ID " + instrument.getId());
            }
            if (processedOutputIds.contains(dto.getOutputId())) {
                throw new InvalidInputException("Output duplicado: " + output.getName());
            }
            processedOutputIds.add(dto.getOutputId());
            int outputIndex = Optional.ofNullable(dto.getOutputIndex()).orElse(nextAvailableIndex);
            if (usedIndices.contains(outputIndex)) {
                throw new InvalidInputException("\u00cdndice duplicado: " + outputIndex);
            }
            usedIndices.add(outputIndex);
            InstrumentTabulateOutputAssociationEntity outputAssociation = new InstrumentTabulateOutputAssociationEntity();
            outputAssociation.setId(dto.getId());
            outputAssociation.setAssociation(association);
            outputAssociation.setOutput(output);
            outputAssociation.setOutputIndex(Integer.valueOf(outputIndex));
            outputAssociations.add(outputAssociation);
            nextAvailableIndex = this.getNextAvailableIndex(usedIndices);
        }
        association.setOutputAssociations(outputAssociations);
    }

    private int getNextAvailableIndex(Set<Integer> usedIndices) {
        int index = 1;
        while (usedIndices.contains(index)) {
            ++index;
        }
        return index;
    }

    @Generated
    public InstrumentTabulatePatternService(InstrumentTabulatePatternRepository patternRepository, DamService damService, InstrumentService instrumentService, OutputService outputService, InstrumentTabulatePatternFolderService folderService, InstrumentTabulatePatternMapper mapper) {
        this.patternRepository = patternRepository;
        this.damService = damService;
        this.instrumentService = instrumentService;
        this.outputService = outputService;
        this.folderService = folderService;
        this.mapper = mapper;
    }
}

