/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.deterministic_limit.services;

import com.geosegbar.entities.DeterministicLimitEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.deterministic_limit.persistence.jpa.DeterministicLimitRepository;
import com.geosegbar.infra.output.persistence.jpa.OutputRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeterministicLimitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeterministicLimitService.class);
    private final DeterministicLimitRepository deterministicLimitRepository;
    private final OutputRepository outputRepository;

    public Optional<DeterministicLimitEntity> findByOutputId(Long outputId) {
        return this.deterministicLimitRepository.findByOutputId(outputId);
    }

    public List<Long> findDeterministicLimitIdsByOutputInstrumentDamId(Long damId) {
        return this.deterministicLimitRepository.findLimitIdsByOutputInstrumentDamId(damId);
    }

    public DeterministicLimitEntity findById(Long id) {
        return (DeterministicLimitEntity)this.deterministicLimitRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Limite determin\u00edstico n\u00e3o encontrado com ID: " + id));
    }

    @Transactional
    public DeterministicLimitEntity createOrUpdate(Long outputId, DeterministicLimitEntity limit) {
        OutputEntity output = (OutputEntity)this.outputRepository.findById((Object)outputId).orElseThrow(() -> new NotFoundException("Output n\u00e3o encontrado com ID: " + outputId));
        InstrumentEntity instrument = output.getInstrument();
        if (instrument == null) {
            throw new InvalidInputException("Output sem instrumento associado!");
        }
        if (Boolean.TRUE.equals(instrument.getNoLimit())) {
            throw new InvalidInputException("N\u00e3o \u00e9 poss\u00edvel adicionar limites a um output de um instrumento marcado como 'Sem Limites'!");
        }
        if (output.getStatisticalLimit() != null) {
            throw new InvalidInputException("Este output j\u00e1 possui limite estat\u00edstico. N\u00e3o \u00e9 poss\u00edvel ter ambos os tipos de limite!");
        }
        Optional existingLimit = this.deterministicLimitRepository.findByOutputId(outputId);
        if (existingLimit.isPresent()) {
            DeterministicLimitEntity existingEntity = (DeterministicLimitEntity)existingLimit.get();
            existingEntity.setAttentionValue(limit.getAttentionValue());
            existingEntity.setAlertValue(limit.getAlertValue());
            existingEntity.setEmergencyValue(limit.getEmergencyValue());
            return (DeterministicLimitEntity)this.deterministicLimitRepository.save((Object)existingEntity);
        }
        limit.setOutput(output);
        DeterministicLimitEntity savedLimit = (DeterministicLimitEntity)this.deterministicLimitRepository.save((Object)limit);
        output.setDeterministicLimit(savedLimit);
        this.outputRepository.save((Object)output);
        return savedLimit;
    }

    @Transactional
    public void deleteById(Long id) {
        DeterministicLimitEntity limit = this.findById(id);
        OutputEntity output = limit.getOutput();
        if (output != null) {
            output.setDeterministicLimit(null);
            this.outputRepository.save((Object)output);
        }
        this.deterministicLimitRepository.delete((Object)limit);
        log.info("Limite determin\u00edstico exclu\u00eddo para o output ID: {}", output != null ? output.getId() : "desconhecido");
    }

    @Generated
    public DeterministicLimitService(DeterministicLimitRepository deterministicLimitRepository, OutputRepository outputRepository) {
        this.deterministicLimitRepository = deterministicLimitRepository;
        this.outputRepository = outputRepository;
    }
}

