/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist.persistence.jpa;

import com.geosegbar.entities.ChecklistEntity;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ChecklistRepository
extends JpaRepository<ChecklistEntity, Long> {
    @EntityGraph(attributePaths={"templateQuestionnaires", "dams"})
    public List<ChecklistEntity> findByDams_Id(Long var1);

    @EntityGraph(attributePaths={"templateQuestionnaires", "templateQuestionnaires.templateQuestions", "templateQuestionnaires.templateQuestions.question", "templateQuestionnaires.templateQuestions.question.options", "dams"})
    @Query(value="SELECT c FROM ChecklistEntity c JOIN c.dams d WHERE d.id = :damId")
    public List<ChecklistEntity> findByDamIdWithFullDetails(@Param(value="damId") Long var1);

    @EntityGraph(attributePaths={"templateQuestionnaires", "templateQuestionnaires.templateQuestions", "templateQuestionnaires.templateQuestions.question", "templateQuestionnaires.templateQuestions.question.options", "dams"})
    @Query(value="SELECT c FROM ChecklistEntity c WHERE c.id = :id")
    public Optional<ChecklistEntity> findByIdWithFullDetails(@Param(value="id") Long var1);

    public Optional<ChecklistEntity> findByNameIgnoreCase(String var1);

    @EntityGraph(attributePaths={"dams"})
    @Query(value="SELECT c FROM ChecklistEntity c WHERE c.id = :checklistId")
    public Optional<ChecklistEntity> findByIdWithDams(@Param(value="checklistId") Long var1);

    public boolean existsByName(String var1);

    public boolean existsByNameAndIdNot(String var1, Long var2);

    public boolean existsByNameAndDams_Id(String var1, Long var2);

    public boolean existsByNameAndDams_IdAndIdNot(String var1, Long var2, Long var3);
}

