/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.documentation_permission.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.DocumentationPermissionEntity;
import com.geosegbar.infra.permissions.documentation_permission.dtos.DocumentationPermissionDTO;
import com.geosegbar.infra.permissions.documentation_permission.services.DocumentationPermissionService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/documentation-permission"})
public class DocumentationPermissionController {
    private final DocumentationPermissionService docPermissionService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<DocumentationPermissionEntity>>> getAllDocumentationPermissions() {
        List<DocumentationPermissionEntity> permissions = this.docPermissionService.findAll();
        WebResponseEntity<List<DocumentationPermissionEntity>> response = WebResponseEntity.success(permissions, "Permiss\u00f5es de documenta\u00e7\u00e3o obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<DocumentationPermissionEntity>> getDocumentationPermissionById(@PathVariable Long id) {
        DocumentationPermissionEntity permission = this.docPermissionService.findById(id);
        WebResponseEntity<DocumentationPermissionEntity> response = WebResponseEntity.success(permission, "Permiss\u00e3o de documenta\u00e7\u00e3o obtida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/user/{userId}"})
    public ResponseEntity<WebResponseEntity<DocumentationPermissionEntity>> getDocumentationPermissionByUser(@PathVariable Long userId) {
        DocumentationPermissionEntity permission = this.docPermissionService.findByUser(userId);
        WebResponseEntity<DocumentationPermissionEntity> response = WebResponseEntity.success(permission, "Permiss\u00e3o de documenta\u00e7\u00e3o do usu\u00e1rio obtida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<DocumentationPermissionEntity>> createDocumentationPermission(@Valid @RequestBody DocumentationPermissionDTO permissionDTO) {
        DocumentationPermissionEntity permission = this.docPermissionService.createOrUpdate(permissionDTO);
        WebResponseEntity<DocumentationPermissionEntity> response = WebResponseEntity.success(permission, "Permiss\u00e3o de documenta\u00e7\u00e3o criada com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<DocumentationPermissionEntity>> updateDocumentationPermission(@PathVariable Long id, @Valid @RequestBody DocumentationPermissionDTO permissionDTO) {
        permissionDTO.setId(id);
        DocumentationPermissionEntity permission = this.docPermissionService.createOrUpdate(permissionDTO);
        WebResponseEntity<DocumentationPermissionEntity> response = WebResponseEntity.success(permission, "Permiss\u00e3o de documenta\u00e7\u00e3o atualizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteDocumentationPermission(@PathVariable Long id) {
        this.docPermissionService.delete(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Permiss\u00e3o de documenta\u00e7\u00e3o exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/user/{userId}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteDocumentationPermissionByUser(@PathVariable Long userId) {
        this.docPermissionService.deleteByUser(userId);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Permiss\u00e3o de documenta\u00e7\u00e3o do usu\u00e1rio exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public DocumentationPermissionController(DocumentationPermissionService docPermissionService) {
        this.docPermissionService = docPermissionService;
    }
}

