/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_type.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.infra.instrument_type.dtos.InstrumentTypeDTO;
import com.geosegbar.infra.instrument_type.services.InstrumentTypeService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/instrument-types"})
public class InstrumentTypeController {
    private final InstrumentTypeService instrumentTypeService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<InstrumentTypeDTO>>> getAllTypes() {
        return ResponseEntity.ok(WebResponseEntity.success(this.instrumentTypeService.findAll(), "Tipos de instrumentos obtidos com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<InstrumentTypeDTO>> getTypeById(@PathVariable Long id) {
        return ResponseEntity.ok(WebResponseEntity.success(this.instrumentTypeService.findById(id), "Tipo de instrumento obtido com sucesso!"));
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<InstrumentTypeDTO>> createType(@Valid @RequestBody InstrumentTypeDTO request) {
        return new ResponseEntity(WebResponseEntity.success(this.instrumentTypeService.create(request), "Tipo de instrumento criado com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<InstrumentTypeDTO>> updateType(@PathVariable Long id, @Valid @RequestBody InstrumentTypeDTO request) {
        return ResponseEntity.ok(WebResponseEntity.success(this.instrumentTypeService.update(id, request), "Tipo de instrumento atualizado com sucesso!"));
    }

    @Generated
    public InstrumentTypeController(InstrumentTypeService instrumentTypeService) {
        this.instrumentTypeService = instrumentTypeService;
    }
}

