/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.danger_level.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.DangerLevelEntity;
import com.geosegbar.infra.danger_level.services.DangerLevelService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/danger-levels"})
public class DangerLevelController {
    private final DangerLevelService dangerLevelService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<DangerLevelEntity>>> getAllDangerLevels() {
        List<DangerLevelEntity> dangerLevels = this.dangerLevelService.findAll();
        WebResponseEntity<List<DangerLevelEntity>> response = WebResponseEntity.success(dangerLevels, "Danger levels retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<DangerLevelEntity>> getDangerLevelById(@PathVariable Long id) {
        DangerLevelEntity dangerLevel = this.dangerLevelService.findById(id);
        WebResponseEntity<DangerLevelEntity> response = WebResponseEntity.success(dangerLevel, "Danger level retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/name/{name}"})
    public ResponseEntity<WebResponseEntity<DangerLevelEntity>> getDangerLevelByName(@PathVariable String name) {
        DangerLevelEntity dangerLevel = this.dangerLevelService.findByName(name);
        WebResponseEntity<DangerLevelEntity> response = WebResponseEntity.success(dangerLevel, "Danger level retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public DangerLevelController(DangerLevelService dangerLevelService) {
        this.dangerLevelService = dangerLevelService;
    }
}

