/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.client.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.infra.client.dtos.LogoUpdateDTO;
import com.geosegbar.infra.client.service.ClientService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/client"})
public class ClientController {
    private final ClientService clientService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<ClientEntity>>> getAllClients() {
        List<ClientEntity> clients = this.clientService.findAll();
        WebResponseEntity<List<ClientEntity>> response = WebResponseEntity.success(clients, "Clientes obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> getClientById(@PathVariable Long id) {
        ClientEntity client = this.clientService.findById(id);
        WebResponseEntity<ClientEntity> response = WebResponseEntity.success(client, "Cliente obtido com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/filter"})
    public ResponseEntity<WebResponseEntity<List<ClientEntity>>> getClientsByStatus(@RequestParam(required=false) Long statusId) {
        List<ClientEntity> clients = this.clientService.findByStatus(statusId);
        WebResponseEntity<List<ClientEntity>> response = WebResponseEntity.success(clients, "Clientes filtrados obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<ClientEntity>> createClient(@Valid @RequestBody ClientEntity client) {
        ClientEntity createdClient = this.clientService.save(client);
        WebResponseEntity<ClientEntity> response = WebResponseEntity.success(createdClient, "Cliente criado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> updateClient(@PathVariable Long id, @Valid @RequestBody ClientEntity client) {
        client.setId(id);
        ClientEntity updatedClient = this.clientService.update(client);
        WebResponseEntity<ClientEntity> response = WebResponseEntity.success(updatedClient, "Cliente atualizado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/{id}/logo"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> updateLogo(@PathVariable Long id, @RequestBody LogoUpdateDTO logoUpdateDTO) {
        ClientEntity updatedClient = this.clientService.updateLogo(id, logoUpdateDTO);
        WebResponseEntity<ClientEntity> response = WebResponseEntity.success(updatedClient, "Logo do cliente atualizado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}/logo"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> removeLogo(@PathVariable Long id) {
        ClientEntity updatedClient = this.clientService.updateLogo(id, null);
        WebResponseEntity<ClientEntity> response = WebResponseEntity.success(updatedClient, "Logo do cliente removido com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteClient(@PathVariable Long id) {
        this.clientService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Cliente deletado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public ClientController(ClientService clientService) {
        this.clientService = clientService;
    }
}

