/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.anomaly.services;

import com.geosegbar.entities.AnomalyEntity;
import com.geosegbar.entities.AnomalyPhotoEntity;
import com.geosegbar.entities.AnomalyStatusEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DangerLevelEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.FileStorageException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.anomaly.dtos.AnomalyDTO;
import com.geosegbar.infra.anomaly.persistence.jpa.AnomalyRepository;
import com.geosegbar.infra.anomaly_photo.persistence.jpa.AnomalyPhotoRepository;
import com.geosegbar.infra.anomaly_status.persistence.jpa.AnomalyStatusRepository;
import com.geosegbar.infra.checklist_submission.dtos.PhotoSubmissionDTO;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.danger_level.persistence.jpa.DangerLevelRepository;
import com.geosegbar.infra.file_storage.FileStorageService;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AnomalyService {
    private final AnomalyRepository anomalyRepository;
    private final UserRepository userRepository;
    private final DamRepository damRepository;
    private final DangerLevelRepository dangerLevelRepository;
    private final AnomalyStatusRepository statusRepository;
    private final FileStorageService fileStorageService;
    private final AnomalyPhotoRepository anomalyPhotoRepository;

    @PostConstruct
    public void init() {
        this.initDangerLevels();
        this.initAnomalyStatuses();
    }

    private void initDangerLevels() {
        if (this.dangerLevelRepository.count() == 0L) {
            this.dangerLevelRepository.save(new DangerLevelEntity(null, "Normal", "N\u00edvel de perigo normal"));
            this.dangerLevelRepository.save(new DangerLevelEntity(null, "Aten\u00e7\u00e3o", "N\u00edvel de perigo aten\u00e7\u00e3o"));
            this.dangerLevelRepository.save(new DangerLevelEntity(null, "Alerta", "N\u00edvel de perigo alerta"));
            this.dangerLevelRepository.save(new DangerLevelEntity(null, "Emerg\u00eancia", "N\u00edvel de perigo emerg\u00eancia"));
        }
    }

    private void initAnomalyStatuses() {
        if (this.statusRepository.count() == 0L) {
            this.statusRepository.save(new AnomalyStatusEntity(null, "Pendente", "Anomalia pendente"));
            this.statusRepository.save(new AnomalyStatusEntity(null, "Em andamento", "Anomalia em andamento"));
            this.statusRepository.save(new AnomalyStatusEntity(null, "Conclu\u00eddo", "Anomalia conclu\u00edda"));
            this.statusRepository.save(new AnomalyStatusEntity(null, "Em monitoramento", "Anomalia em monitoramento"));
        }
    }

    public List<AnomalyEntity> findAll() {
        return this.anomalyRepository.findAll();
    }

    public AnomalyEntity findById(Long id) {
        return this.anomalyRepository.findById(id).orElseThrow(() -> new NotFoundException("Anomalia n\u00e3o encontrada!"));
    }

    public List<AnomalyEntity> findByDamId(Long damId) {
        return this.anomalyRepository.findByDamId(damId);
    }

    @Transactional
    public AnomalyEntity create(AnomalyDTO request) {
        UserEntity user = (UserEntity)this.userRepository.findById(request.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        DamEntity dam = (DamEntity)this.damRepository.findById(request.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada!"));
        DangerLevelEntity dangerLevel = (DangerLevelEntity)this.dangerLevelRepository.findById(request.getDangerLevelId()).orElseThrow(() -> new NotFoundException("N\u00edvel de perigo n\u00e3o encontrado!"));
        AnomalyStatusEntity status = (AnomalyStatusEntity)this.statusRepository.findById(request.getStatusId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado!"));
        AnomalyEntity anomaly = new AnomalyEntity();
        anomaly.setUser(user);
        anomaly.setDam(dam);
        anomaly.setLatitude(request.getLatitude());
        anomaly.setLongitude(request.getLongitude());
        anomaly.setQuestionnaireId(request.getQuestionnaireId());
        anomaly.setQuestionId(request.getQuestionId());
        anomaly.setOrigin(request.getOrigin());
        anomaly.setObservation(request.getObservation());
        anomaly.setRecommendation(request.getRecommendation());
        anomaly.setDangerLevel(dangerLevel);
        anomaly.setStatus(status);
        AnomalyEntity savedAnomaly = (AnomalyEntity)this.anomalyRepository.save(anomaly);
        if (request.getPhotos() != null && !request.getPhotos().isEmpty()) {
            for (PhotoSubmissionDTO photoDto : request.getPhotos()) {
                this.saveAnomalyPhoto(photoDto, savedAnomaly, dam.getId());
            }
        }
        return savedAnomaly;
    }

    @Transactional
    public AnomalyEntity update(Long id, AnomalyDTO request) {
        AnomalyEntity anomaly = this.findById(id);
        UserEntity user = (UserEntity)this.userRepository.findById(request.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        DamEntity dam = (DamEntity)this.damRepository.findById(request.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada!"));
        DangerLevelEntity dangerLevel = (DangerLevelEntity)this.dangerLevelRepository.findById(request.getDangerLevelId()).orElseThrow(() -> new NotFoundException("N\u00edvel de perigo n\u00e3o encontrado!"));
        AnomalyStatusEntity status = (AnomalyStatusEntity)this.statusRepository.findById(request.getStatusId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado!"));
        anomaly.setUser(user);
        anomaly.setDam(dam);
        anomaly.setLatitude(request.getLatitude());
        anomaly.setLongitude(request.getLongitude());
        anomaly.setQuestionnaireId(request.getQuestionnaireId());
        anomaly.setQuestionId(request.getQuestionId());
        anomaly.setOrigin(request.getOrigin());
        anomaly.setObservation(request.getObservation());
        anomaly.setRecommendation(request.getRecommendation());
        anomaly.setDangerLevel(dangerLevel);
        anomaly.setStatus(status);
        if (request.getPhotos() != null && !request.getPhotos().isEmpty()) {
            for (AnomalyPhotoEntity photo : new ArrayList<AnomalyPhotoEntity>(anomaly.getPhotos())) {
                if (photo.getImagePath() != null && !photo.getImagePath().isEmpty()) {
                    this.fileStorageService.deleteFile(photo.getImagePath());
                }
                this.anomalyPhotoRepository.delete(photo);
            }
            anomaly.getPhotos().clear();
            for (PhotoSubmissionDTO photoDto : request.getPhotos()) {
                this.saveAnomalyPhoto(photoDto, anomaly, dam.getId());
            }
        }
        return (AnomalyEntity)this.anomalyRepository.save(anomaly);
    }

    @Transactional
    public void delete(Long id) {
        AnomalyEntity anomaly = this.findById(id);
        for (AnomalyPhotoEntity photo : anomaly.getPhotos()) {
            if (photo.getImagePath() == null || photo.getImagePath().isEmpty()) continue;
            this.fileStorageService.deleteFile(photo.getImagePath());
        }
        this.anomalyRepository.delete(anomaly);
    }

    private AnomalyPhotoEntity saveAnomalyPhoto(PhotoSubmissionDTO photoDto, AnomalyEntity anomaly, Long damId) {
        try {
            String base64Image = photoDto.getBase64Image();
            if (base64Image.contains(",")) {
                base64Image = base64Image.split(",")[1];
            }
            byte[] imageBytes = Base64.getDecoder().decode(base64Image);
            String photoUrl = this.fileStorageService.storeFileFromBytes(imageBytes, photoDto.getFileName(), photoDto.getContentType(), "anomalies");
            AnomalyPhotoEntity photoEntity = new AnomalyPhotoEntity();
            photoEntity.setAnomaly(anomaly);
            photoEntity.setImagePath(photoUrl);
            photoEntity.setDamId(damId);
            return (AnomalyPhotoEntity)this.anomalyPhotoRepository.save(photoEntity);
        }
        catch (Exception e) {
            throw new FileStorageException("Erro ao processar imagem da anomalia: " + e.getMessage());
        }
    }

    @Generated
    public AnomalyService(AnomalyRepository anomalyRepository, UserRepository userRepository, DamRepository damRepository, DangerLevelRepository dangerLevelRepository, AnomalyStatusRepository statusRepository, FileStorageService fileStorageService, AnomalyPhotoRepository anomalyPhotoRepository) {
        this.anomalyRepository = anomalyRepository;
        this.userRepository = userRepository;
        this.damRepository = damRepository;
        this.dangerLevelRepository = dangerLevelRepository;
        this.statusRepository = statusRepository;
        this.fileStorageService = fileStorageService;
        this.anomalyPhotoRepository = anomalyPhotoRepository;
    }
}

