/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.common.email;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Service
public class EmailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    private final JavaMailSender mailSender;
    private final TemplateEngine templateEngine;
    @Value(value="${spring.mail.username}")
    private String fromEmail;
    @Value(value="${application.frontend-url:https://geometrisa-prod.com.br}")
    private String frontendUrl;

    @Async
    public void sendVerificationCode(String toEmail, String code) {
        try {
            Context context = new Context();
            context.setVariable("code", (Object)code);
            String htmlContent = this.templateEngine.process("emails/verification-code", (IContext)context);
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom(this.fromEmail);
            helper.setTo(toEmail);
            helper.setSubject("C\u00f3digo de Verifica\u00e7\u00e3o - GeoSegBar");
            helper.setText(htmlContent, true);
            this.mailSender.send(message);
            log.info("Email de verifica\u00e7\u00e3o enviado para: {}", (Object)toEmail);
        }
        catch (MessagingException e) {
            log.error("Erro ao enviar email de verifica\u00e7\u00e3o: {}", (Object)e.getMessage());
        }
    }

    @Async
    public void sendPasswordResetCode(String toEmail, String code) {
        try {
            Context context = new Context();
            context.setVariable("code", (Object)code);
            String htmlContent = this.templateEngine.process("emails/password-reset-code", (IContext)context);
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom(this.fromEmail);
            helper.setTo(toEmail);
            helper.setSubject("Redefini\u00e7\u00e3o de Senha - GeoSegBar");
            helper.setText(htmlContent, true);
            this.mailSender.send(message);
            log.info("Email de redefini\u00e7\u00e3o de senha enviado para: {}", (Object)toEmail);
        }
        catch (MessagingException e) {
            log.error("Erro ao enviar email de redefini\u00e7\u00e3o de senha: {}", (Object)e.getMessage());
        }
    }

    @Async
    public void sendFirstAccessPassword(String toEmail, String password, String userName) {
        try {
            Context context = new Context();
            context.setVariable("password", (Object)password);
            context.setVariable("userName", (Object)userName);
            context.setVariable("userEmail", (Object)toEmail);
            String htmlContent = this.templateEngine.process("emails/first-access-password", (IContext)context);
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom(this.fromEmail);
            helper.setTo(toEmail);
            helper.setSubject("Bem-vindo ao GeoSegBar - Sua senha de acesso");
            helper.setText(htmlContent, true);
            this.mailSender.send(message);
            log.info("Email de primeiro acesso enviado para: {}", (Object)toEmail);
        }
        catch (MessagingException e) {
            log.error("Erro ao enviar email de primeiro acesso: {}", (Object)e.getMessage());
        }
    }

    @Async
    public void sendShareFolderEmail(String to, String sharedByName, String folderName, String token) {
        try {
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.fromEmail);
            helper.setTo(to);
            helper.setSubject("Pasta compartilhada: " + folderName);
            Context context = new Context();
            context.setVariable("sharedByName", (Object)sharedByName);
            context.setVariable("folderName", (Object)folderName);
            context.setVariable("accessLink", (Object)(this.frontendUrl + "/shared/folder/" + token));
            String content = this.templateEngine.process("emails/share-folder", (IContext)context);
            helper.setText(content, true);
            this.mailSender.send(mimeMessage);
            log.info("Email de compartilhamento enviado para: {}", (Object)to);
        }
        catch (MessagingException e) {
            log.error("Erro ao enviar email de compartilhamento: {}", (Object)e.getMessage());
        }
    }

    @Generated
    public EmailService(JavaMailSender mailSender, TemplateEngine templateEngine) {
        this.mailSender = mailSender;
        this.templateEngine = templateEngine;
    }
}

