/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.status.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.StatusEntity;
import com.geosegbar.infra.status.services.StatusService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/status"})
public class StatusController {
    private final StatusService statusService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<StatusEntity>>> getAllStatuses() {
        List<StatusEntity> statuses = this.statusService.findAll();
        WebResponseEntity<List<StatusEntity>> response = WebResponseEntity.success(statuses, "Status retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<StatusEntity>> getStatusById(@PathVariable Long id) {
        StatusEntity status = this.statusService.findById(id);
        WebResponseEntity<StatusEntity> response = WebResponseEntity.success(status, "Status retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/active"})
    public ResponseEntity<WebResponseEntity<StatusEntity>> getActiveStatus() {
        StatusEntity status = this.statusService.getActiveStatus();
        WebResponseEntity<StatusEntity> response = WebResponseEntity.success(status, "Active status retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/disabled"})
    public ResponseEntity<WebResponseEntity<StatusEntity>> getDisabledStatus() {
        StatusEntity status = this.statusService.getDisabledStatus();
        WebResponseEntity<StatusEntity> response = WebResponseEntity.success(status, "Disabled status retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public StatusController(StatusService statusService) {
        this.statusService = statusService;
    }
}

