/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.questionnaire_response.persistence.jpa;

import com.geosegbar.entities.QuestionnaireResponseEntity;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface QuestionnaireResponseRepository
extends JpaRepository<QuestionnaireResponseEntity, Long> {
    @EntityGraph(attributePaths={"templateQuestionnaire", "answers"})
    public List<QuestionnaireResponseEntity> findByDamId(Long var1);

    public List<QuestionnaireResponseEntity> findByChecklistResponseId(Long var1);

    @EntityGraph(attributePaths={"templateQuestionnaire", "answers"})
    public List<QuestionnaireResponseEntity> findByDamIdAndCreatedAtBetween(Long var1, LocalDateTime var2, LocalDateTime var3);

    public boolean existsByTemplateQuestionnaireId(Long var1);

    @EntityGraph(attributePaths={"templateQuestionnaire", "answers", "answers.selectedOptions", "answers.question", "answers.photos"})
    @Query(value="SELECT qr FROM QuestionnaireResponseEntity qr WHERE qr.checklistResponse.id = :checklistResponseId")
    public List<QuestionnaireResponseEntity> findByChecklistResponseIdOptimized(@Param(value="checklistResponseId") Long var1);

    @Query(value="SELECT qr FROM QuestionnaireResponseEntity qr JOIN qr.answers a JOIN a.selectedOptions o WHERE qr.templateQuestionnaire.id = :templateId AND a.question.id = :questionId AND o.id = :optionId ORDER BY qr.createdAt DESC")
    @EntityGraph(attributePaths={"checklistResponse", "answers", "answers.selectedOptions"})
    public List<QuestionnaireResponseEntity> findResponsesByTemplateQuestionAndOption(@Param(value="templateId") Long var1, @Param(value="questionId") Long var2, @Param(value="optionId") Long var3);

    @Query(value="SELECT DISTINCT qr FROM QuestionnaireResponseEntity qr WHERE qr.dam.id = :damId ORDER BY qr.createdAt DESC")
    @EntityGraph(attributePaths={"templateQuestionnaire", "answers", "answers.selectedOptions", "answers.question", "answers.photos", "checklistResponse"})
    public List<QuestionnaireResponseEntity> findByDamIdWithDetails(@Param(value="damId") Long var1);

    @Query(value="SELECT qr FROM QuestionnaireResponseEntity qr WHERE qr.dam.id = :damId AND qr.templateQuestionnaire.id = :templateId AND qr.createdAt = (SELECT MAX(qr2.createdAt) FROM QuestionnaireResponseEntity qr2                    WHERE qr2.dam.id = :damId AND qr2.templateQuestionnaire.id = :templateId)")
    @EntityGraph(attributePaths={"answers", "answers.selectedOptions", "answers.question"})
    public Optional<QuestionnaireResponseEntity> findLatestByDamIdAndTemplateId(@Param(value="damId") Long var1, @Param(value="templateId") Long var2);
}

