/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.infra.instrument.dtos.CreateInstrumentRequest;
import com.geosegbar.infra.instrument.dtos.InstrumentResponseDTO;
import com.geosegbar.infra.instrument.dtos.UpdateInstrumentRequest;
import com.geosegbar.infra.instrument.services.InstrumentService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/instruments"})
public class InstrumentController {
    private final InstrumentService instrumentService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<InstrumentResponseDTO>>> getAllInstruments() {
        List<InstrumentEntity> instruments = this.instrumentService.findAll();
        List<InstrumentResponseDTO> dtos = this.instrumentService.mapToResponseDTOList(instruments);
        return ResponseEntity.ok(WebResponseEntity.success(dtos, "Instrumentos obtidos com sucesso!"));
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<InstrumentResponseDTO>>> getInstrumentsByDam(@PathVariable Long damId) {
        List<InstrumentEntity> instruments = this.instrumentService.findByDamId(damId);
        List<InstrumentResponseDTO> dtos = this.instrumentService.mapToResponseDTOList(instruments);
        return ResponseEntity.ok(WebResponseEntity.success(dtos, "Instrumentos da barragem obtidos com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<InstrumentResponseDTO>> getInstrumentById(@PathVariable Long id) {
        InstrumentEntity instrument = this.instrumentService.findWithAllDetails(id);
        InstrumentResponseDTO dto = this.instrumentService.mapToResponseDTO(instrument);
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Instrumento obtido com sucesso!"));
    }

    @GetMapping(value={"/filter"})
    public ResponseEntity<WebResponseEntity<List<InstrumentResponseDTO>>> filterInstruments(@RequestParam(required=false) Long damId, @RequestParam(required=false) Long instrumentTypeId, @RequestParam(required=false) Long sectionId, @RequestParam(required=false) Boolean active, @RequestParam(required=false) Long clientId) {
        List<InstrumentEntity> instruments = this.instrumentService.findByFilters(damId, instrumentTypeId, sectionId, active, clientId);
        List<InstrumentResponseDTO> responseList = this.instrumentService.mapToResponseDTOList(instruments);
        return ResponseEntity.ok(WebResponseEntity.success(responseList, "Instrumentos obtidos com sucesso!"));
    }

    @GetMapping(value={"/client/{clientId}"})
    public ResponseEntity<WebResponseEntity<List<InstrumentResponseDTO>>> getInstrumentsByClient(@PathVariable Long clientId, @RequestParam(required=false) Boolean active) {
        List<InstrumentEntity> instruments = this.instrumentService.findByClientId(clientId, active);
        List<InstrumentResponseDTO> dtos = this.instrumentService.mapToResponseDTOList(instruments);
        return ResponseEntity.ok(WebResponseEntity.success(dtos, "Instrumentos do cliente obtidos com sucesso!"));
    }

    @PatchMapping(value={"/{id}/{active}"})
    public ResponseEntity<WebResponseEntity<InstrumentResponseDTO>> activateInstrument(@PathVariable Long id, @PathVariable Boolean active) {
        InstrumentEntity instrument = this.instrumentService.toggleActiveInstrument(id, active);
        InstrumentResponseDTO response = this.instrumentService.mapToResponseDTO(instrument);
        String action = active != false ? "ativado" : "desativado";
        return ResponseEntity.ok(WebResponseEntity.success(response, "Instrumento " + action + " com sucesso!"));
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<InstrumentResponseDTO>> createInstrument(@Valid @RequestBody CreateInstrumentRequest request) {
        InstrumentEntity createdInstrument = this.instrumentService.createComplete(request);
        InstrumentResponseDTO dto = this.instrumentService.mapToResponseDTO(createdInstrument);
        return new ResponseEntity(WebResponseEntity.success(dto, "Instrumento criado com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<InstrumentResponseDTO>> update(@PathVariable Long id, @Valid @RequestBody UpdateInstrumentRequest request) {
        InstrumentEntity updated = this.instrumentService.update(id, request);
        return ResponseEntity.ok(WebResponseEntity.success(this.instrumentService.mapToResponseDTO(updated), "Instrumento atualizado com sucesso!"));
    }

    @PatchMapping(value={"/{id}/section-visibility/{active}"})
    public ResponseEntity<WebResponseEntity<InstrumentResponseDTO>> toggleSectionVisibility(@PathVariable Long id, @PathVariable Boolean active) {
        InstrumentEntity instrument = this.instrumentService.toggleSectionVisibility(id, active);
        InstrumentResponseDTO response = this.instrumentService.mapToResponseDTO(instrument);
        String action = active != false ? "vis\u00edvel" : "oculto";
        return ResponseEntity.ok(WebResponseEntity.success(response, "Instrumento " + action + " na aba de se\u00e7\u00f5es com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteInstrument(@PathVariable Long id) {
        this.instrumentService.delete(id);
        return ResponseEntity.ok(WebResponseEntity.success(null, "Instrumento exclu\u00eddo com sucesso!"));
    }

    @Generated
    public InstrumentController(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }
}

