/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.documentation_dam.services;

import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DocumentationDamEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.documentation_dam.dtos.DocumentationDamDTO;
import com.geosegbar.infra.documentation_dam.persistence.DocumentationDamRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocumentationDamService {
    private final DocumentationDamRepository documentationDamRepository;
    private final DamRepository damRepository;

    public DocumentationDamEntity findById(Long id) {
        return (DocumentationDamEntity)this.documentationDamRepository.findById(id).orElseThrow(() -> new NotFoundException("Documenta\u00e7\u00e3o de barragem n\u00e3o encontrada com ID: " + id));
    }

    public DocumentationDamEntity findByDamId(Long damId) {
        return this.documentationDamRepository.findByDamId(damId).orElseThrow(() -> new NotFoundException("Documenta\u00e7\u00e3o n\u00e3o encontrada para a barragem com ID: " + damId));
    }

    public List<DocumentationDamEntity> findAll() {
        return this.documentationDamRepository.findAll();
    }

    @Transactional
    public DocumentationDamEntity createOrUpdate(DocumentationDamDTO documentationDamDTO) {
        DocumentationDamEntity documentationDam;
        DamEntity dam = (DamEntity)this.damRepository.findById(documentationDamDTO.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + documentationDamDTO.getDamId()));
        if (documentationDamDTO.getId() != null) {
            documentationDam = (DocumentationDamEntity)this.documentationDamRepository.findById(documentationDamDTO.getId()).orElseThrow(() -> new NotFoundException("Documenta\u00e7\u00e3o de barragem n\u00e3o encontrada com ID: " + documentationDamDTO.getId()));
            if (!documentationDam.getDam().getId().equals(documentationDamDTO.getDamId())) {
                throw new DuplicateResourceException("N\u00e3o \u00e9 permitido mudar a barragem associada \u00e0 documenta\u00e7\u00e3o");
            }
        } else {
            if (this.documentationDamRepository.existsByDam(dam)) {
                throw new DuplicateResourceException("J\u00e1 existe documenta\u00e7\u00e3o para esta barragem");
            }
            documentationDam = new DocumentationDamEntity();
            documentationDam.setDam(dam);
            dam.setDocumentationDam(documentationDam);
        }
        documentationDam.setLastUpdatePAE(documentationDamDTO.getLastUpdatePAE());
        documentationDam.setNextUpdatePAE(documentationDamDTO.getNextUpdatePAE());
        documentationDam.setLastUpdatePSB(documentationDamDTO.getLastUpdatePSB());
        documentationDam.setNextUpdatePSB(documentationDamDTO.getNextUpdatePSB());
        documentationDam.setLastUpdateRPSB(documentationDamDTO.getLastUpdateRPSB());
        documentationDam.setNextUpdateRPSB(documentationDamDTO.getNextUpdateRPSB());
        documentationDam.setLastAchievementISR(documentationDamDTO.getLastAchievementISR());
        documentationDam.setNextAchievementISR(documentationDamDTO.getNextAchievementISR());
        documentationDam.setLastAchievementChecklist(documentationDamDTO.getLastAchievementChecklist());
        documentationDam.setNextAchievementChecklist(documentationDamDTO.getNextAchievementChecklist());
        documentationDam.setLastFillingFSB(documentationDamDTO.getLastFillingFSB());
        documentationDam.setNextFillingFSB(documentationDamDTO.getNextFillingFSB());
        documentationDam.setLastInternalSimulation(documentationDamDTO.getLastInternalSimulation());
        documentationDam.setNextInternalSimulation(documentationDamDTO.getNextInternalSimulation());
        documentationDam.setLastExternalSimulation(documentationDamDTO.getLastExternalSimulation());
        documentationDam.setNextExternalSimulation(documentationDamDTO.getNextExternalSimulation());
        return (DocumentationDamEntity)this.documentationDamRepository.save(documentationDam);
    }

    @Transactional
    public void delete(Long id) {
        DocumentationDamEntity documentationDam = (DocumentationDamEntity)this.documentationDamRepository.findById(id).orElseThrow(() -> new NotFoundException("Documenta\u00e7\u00e3o de barragem n\u00e3o encontrada com ID: " + id));
        DamEntity dam = documentationDam.getDam();
        if (dam != null) {
            dam.setDocumentationDam(null);
            this.damRepository.save(dam);
        }
        this.documentationDamRepository.delete(documentationDam);
    }

    @Generated
    public DocumentationDamService(DocumentationDamRepository documentationDamRepository, DamRepository damRepository) {
        this.documentationDamRepository = documentationDamRepository;
        this.damRepository = damRepository;
    }
}

