/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.dam.persistence.jpa;

import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamEntity;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface DamRepository
extends JpaRepository<DamEntity, Long> {
    public List<DamEntity> findAllByOrderByIdAsc();

    public List<DamEntity> findByClient(ClientEntity var1);

    public List<DamEntity> findByClientId(Long var1);

    public boolean existsByName(String var1);

    public boolean existsByNameAndIdNot(String var1, Long var2);

    public boolean existsByNameAndClientId(String var1, Long var2);

    public boolean existsByNameAndClientIdAndIdNot(String var1, Long var2, Long var3);

    @EntityGraph(attributePaths={"psbFolders"})
    public Optional<DamEntity> findWithPsbFoldersById(Long var1);

    @EntityGraph(attributePaths={"reservoirs"})
    public Optional<DamEntity> findWithReservoirsById(Long var1);

    @EntityGraph(attributePaths={"psbFolders"})
    public List<DamEntity> findWithPsbFoldersByClientId(Long var1);

    @EntityGraph(attributePaths={"reservoirs"})
    public List<DamEntity> findWithReservoirsByClientId(Long var1);

    @Query(value="SELECT DISTINCT d FROM DamEntity d WHERE (:clientId IS NULL OR d.client.id = :clientId) AND (:statusId IS NULL OR d.status.id = :statusId)")
    public List<DamEntity> findByClientAndStatus(@Param(value="clientId") Long var1, @Param(value="statusId") Long var2);

    @EntityGraph(attributePaths={"psbFolders", "reservoirs"})
    @Query(value="SELECT DISTINCT d FROM DamEntity d WHERE (:clientId IS NULL OR d.client.id = :clientId) AND (:statusId IS NULL OR d.status.id = :statusId)")
    public List<DamEntity> findWithDetailsByClientAndStatus(@Param(value="clientId") Long var1, @Param(value="statusId") Long var2);
}

