/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.LevelEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@Table(name="reservoirs", indexes={@Index(name="idx_reservoir_dam_id", columnList="dam_id"), @Index(name="idx_reservoir_level_id", columnList="level_id"), @Index(name="idx_reservoir_created_at", columnList="created_at"), @Index(name="idx_reservoir_dam_level", columnList="dam_id, level_id")})
public class ReservoirEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="dam_id", nullable=false)
    @JsonIgnoreProperties(value={"reservoirs", "regulatoryDam", "documentationDam", "checklists", "checklistResponses", "damPermissions"})
    private DamEntity dam;
    @ManyToOne
    @JoinColumn(name="level_id", nullable=false)
    @JsonIgnoreProperties(value={"reservoirs"})
    private LevelEntity level;
    @Column(name="created_at")
    private LocalDateTime createdAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public DamEntity getDam() {
        return this.dam;
    }

    @Generated
    public LevelEntity getLevel() {
        return this.level;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"reservoirs", "regulatoryDam", "documentationDam", "checklists", "checklistResponses", "damPermissions"})
    @Generated
    public void setDam(DamEntity dam) {
        this.dam = dam;
    }

    @JsonIgnoreProperties(value={"reservoirs"})
    @Generated
    public void setLevel(LevelEntity level) {
        this.level = level;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public ReservoirEntity() {
    }

    @Generated
    public ReservoirEntity(Long id, DamEntity dam, LevelEntity level, LocalDateTime createdAt) {
        this.id = id;
        this.dam = dam;
        this.level = level;
        this.createdAt = createdAt;
    }
}

