/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geosegbar.entities.ReservoirEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="levels", indexes={@Index(name="idx_level_name", columnList="name", unique=true), @Index(name="idx_level_value", columnList="value")})
public class LevelEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private Double value;
    @Column(name="unit_level", nullable=false)
    private String unitLevel;
    @Column(name="created_at")
    private LocalDateTime createdAt;
    @JsonIgnore
    @OneToMany(mappedBy="level", fetch=FetchType.LAZY)
    private Set<ReservoirEntity> reservoirs = new HashSet<ReservoirEntity>();

    @PrePersist
    protected void onCreate() {
        this.createdAt = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Double getValue() {
        return this.value;
    }

    @Generated
    public String getUnitLevel() {
        return this.unitLevel;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Set<ReservoirEntity> getReservoirs() {
        return this.reservoirs;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setValue(Double value) {
        this.value = value;
    }

    @Generated
    public void setUnitLevel(String unitLevel) {
        this.unitLevel = unitLevel;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    @Generated
    public void setReservoirs(Set<ReservoirEntity> reservoirs) {
        this.reservoirs = reservoirs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LevelEntity)) {
            return false;
        }
        LevelEntity other = (LevelEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Double this$value = this.getValue();
        Double other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$unitLevel = this.getUnitLevel();
        String other$unitLevel = other.getUnitLevel();
        if (this$unitLevel == null ? other$unitLevel != null : !this$unitLevel.equals(other$unitLevel)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Set<ReservoirEntity> this$reservoirs = this.getReservoirs();
        Set<ReservoirEntity> other$reservoirs = other.getReservoirs();
        return !(this$reservoirs == null ? other$reservoirs != null : !((Object)this$reservoirs).equals(other$reservoirs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LevelEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Double $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $unitLevel = this.getUnitLevel();
        result = result * 59 + ($unitLevel == null ? 43 : $unitLevel.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Set<ReservoirEntity> $reservoirs = this.getReservoirs();
        result = result * 59 + ($reservoirs == null ? 43 : ((Object)$reservoirs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LevelEntity(id=" + this.getId() + ", name=" + this.getName() + ", value=" + this.getValue() + ", unitLevel=" + this.getUnitLevel() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", reservoirs=" + String.valueOf(this.getReservoirs()) + ")";
    }

    @Generated
    public LevelEntity() {
    }

    @Generated
    public LevelEntity(Long id, String name, Double value, String unitLevel, LocalDateTime createdAt, Set<ReservoirEntity> reservoirs) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.unitLevel = unitLevel;
        this.createdAt = createdAt;
        this.reservoirs = reservoirs;
    }
}

